/*
   Run the child with one of its stdout or stderr
   streams not tied to anything. The other output
   stream should be read by this parent process.
   That way, this parent process can see when the
   child fills up its output buffer (and hangs).
*/
import java.io.*;

public class Ex1_OutputBufferCounter_Java7
{
   public static void main(String[] args) throws IOException
   {
      // Create a command line for running the child.
      ProcessBuilder pb = new ProcessBuilder("java", "Ex1_OutputBufferCounter_Child");

      // Have the child inherit this parent's standard error
      // stream and let the child's stdout buffer get filled.
      pb.redirectError( ProcessBuilder.Redirect.INHERIT );
      // Or, have the child inherit this parent's standard out
      // stream and let the child's stderr buffer get filled.
      //pb.redirectOutput( ProcessBuilder.Redirect.INHERIT );

      // Now run the OutputBufferCounter process (which will not terminate).
      Process process = pb.start();  // this throws IOException
   }
}